package gov.va.med.mhv.vitals.repository;

import java.util.List;

import gov.va.med.mhv.vitals.model.BloodPressureReading;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BloodPressureReadingRepository extends JpaRepository<BloodPressureReading, Long>{
	
	     @Query("select a from BloodPressureReading a where a.userprofileId = :userprofileid order by a.reading desc")
		 List<BloodPressureReading>  getBPReadingsForUser(@Param ("userprofileid") Long userprofileid);
	     
	     @Query("select a from BloodPressureReading a where a.userprofileId = :userprofileid order by a.reading desc")
		 List<BloodPressureReading>  getDashBoardBPReadingsForUser(@Param ("userprofileid") Long userprofileid, Pageable page);
	     
	     @Query("select a from BloodPressureReading a where a.userprofileId = :userprofileid and a.id = :id")
	     List<BloodPressureReading> findByIdAndUserProfileId(@Param ("id")Long id, @Param ("userprofileid")Long userProfileId);

}
